﻿var MAX_CARD_NUM = 4;
var cardStatus = new Array(0,0,0,0);;
var gbeNum = new Array(0,0,0,0);
var rfNum = new Array(0,0,0,0);
var cardChMax = new Array(0,0,0,0);

var ABSENT = 0;
var EXIST = 1;

var INPUT_MONITOR = 1;
var OUTPUT_MONITOR = 2;
var contorlName = new Array("", "input", "output");
var BB_TYPE;//背板类型，1-万兆，0-千兆
var X10GBE_GROUP_OFFSET;//万兆组的起始值
var X10GBE_MAX_NUM;//万兆GBE数量
var GBE_PORT = 0;
var RF_PORT = 1;

var language;
var xmlhttp = false;
var getParams;
var i;
var id;
var tempId;
var text;

var returnErrorEn = [""
					,"UDP Port Error!"
					,"Channel Error!"
					,"Parameters Setting timeout!"];
var returnErrorCn = [""
					,"UDP端口错误！"
					,"频点错误！"
					,"参数设置超时！"];
var  returnError = [returnErrorEn, returnErrorCn];
function DisableInputMonitor(boolValue)
{
	document.getElementById("card_input").disabled = boolValue;
	document.getElementById("gbe_port").disabled = boolValue;
	document.getElementById("dst_ip_addr").disabled = boolValue;
	document.getElementById("udp_port").disabled = boolValue;
}

function DisableOutputMonitor(boolValue)
{
	document.getElementById("card_output").disabled = boolValue;
	document.getElementById("rf_port").disabled = boolValue;
	document.getElementById("channel").disabled = boolValue;
}

function CheckMonitorEnable(num)
{
	var obj = document.getElementById(contorlName[num] + "_monitor_enable");
	if(obj.checked == true)
	{
		if(num == 1)
		{
			document.getElementById("output_monitor_enable").checked = false;
			DisableInputMonitor(false);
			DisableOutputMonitor(true);
		}
		else
		{
			document.getElementById("input_monitor_enable").checked = false;
			DisableInputMonitor(true);
			DisableOutputMonitor(false);
		}
	}
	else
	{
		DisableInputMonitor(true);
		DisableOutputMonitor(true);
	}
}

/*type为端口类型，0为GBE Port，1为RF Port
  num为端口添加option数量*/
function addSelectOption(obj, type, num)
{
	if(num == 0)
	{
		if(language == 0)
		{
			text = "None";
		}
		else
		{
			text = "无";
		}
		obj.add(new Option(text, -1));
		return;
	}
	for(i=0; i<num; i++)
	{
		id = i + 1;
		if(type == GBE_PORT)
		{
			text = "GbE " + id;
		}
		else
		{
			if(language == 0)
			{
				text = "RF Port " + id;
			}
			else
			{
				text = "RF 端口 " + id;
			}
		}
		obj.add(new Option(text, i));
	}
	
	if((BB_TYPE == 1) && (type == GBE_PORT))　
	{
		for(i=0; i<X10GBE_MAX_NUM; i++)
		{
			id = i + 1;
			text = "x10GbE " + id;			
			tempId = parseInt(X10GBE_GROUP_OFFSET) + i;//这里的32表示万兆GBE口起始，暂时用固定值代替
			obj.add(new Option(text, tempId));
		}
	}
}

function removeAllOption(obj)
{
	var len = obj.length;
	for(i=0; i<len; i++)
	{
		obj.remove(0);
	}
}

function cardInpChange(num)
{
	var gbePort = document.getElementById("gbe_port");
	removeAllOption(gbePort);
	addSelectOption(gbePort, GBE_PORT, gbeNum[num]);
}

function cardOutpChange(num)
{
	var rfPort = document.getElementById("rf_port");
	removeAllOption(rfPort);
	addSelectOption(rfPort, RF_PORT, rfNum[num]);
}

function UpdateTable()
{
	var cardInput = document.getElementById("card_input");
	var cardOutput = document.getElementById("card_output");
	removeAllOption(cardInput);
	removeAllOption(cardOutput);

	for(i=0; i<MAX_CARD_NUM; i++)
	{
		id = i + 1;
		//if(cardStatus[i] == EXIST)
		//{
			if(language == 0)
			{
				text = "Card " + id;
			}
			else
			{
				text = "卡 " + id;
			}
			cardInput.add(new Option(text, i));
			cardOutput.add(new Option(text, i));
		//}
	}
}

function getDeviceInfo()
{
	var deviceInfo;
	var cardInfo;
	getParams = "type=25&cmd=1&getDeviceInfo=1";

	xmlhttp = getHTTPObject();
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			deviceInfo = xmlhttp.responseText.slice(7, -8);
			deviceInfo = deviceInfo.split("&");
			
			for(i=0; i<MAX_CARD_NUM; i++)
			{
				cardInfo = deviceInfo[i].split(",");
				if(cardInfo[0] == EXIST)
				{
					cardStatus[i] = EXIST;
					gbeNum[i] = cardInfo[1];
					rfNum[i] = cardInfo[2];
					cardChMax[i] = cardInfo[3];
					BB_TYPE = cardInfo[4];
					X10GBE_MAX_NUM = cardInfo[5];
					X10GBE_GROUP_OFFSET = cardInfo[6];
				}
				else
				{
					cardStatus[i] = ABSENT;
				}
			}
			
			UpdateTable();
			GetASIMonitorInfo();
		}
	}
	
	xmlhttp.send(getParams);
	return false;
}

function GetASIMonitorInfo()
{	
	var count = 0;
	getParams = "type=25&cmd=1&getASIMonitorInfo=1";

	xmlhttp = getHTTPObject();
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			var ASIMonitorInfo = xmlhttp.responseText.slice(7, -8).split("&");

			if(ASIMonitorInfo[count++] == 1)
			{
				document.getElementById("input_monitor_enable").checked = true;
				CheckMonitorEnable(INPUT_MONITOR);
			}
			else
			{
				document.getElementById("input_monitor_enable").checked = false;
			}
			
			document.getElementById("card_input").value = ASIMonitorInfo[count++];
			cardInpChange(ASIMonitorInfo[count - 1]);
			document.getElementById("gbe_port").value = ASIMonitorInfo[count++];
			document.getElementById("dst_ip_addr").value = ASIMonitorInfo[count++];
			document.getElementById("udp_port").value = ASIMonitorInfo[count++];
			
			if(ASIMonitorInfo[count++] == 1)
			{
				document.getElementById("output_monitor_enable").checked = true;
				CheckMonitorEnable(OUTPUT_MONITOR);
			}
			else
			{
				document.getElementById("output_monitor_enable").checked = false;
			}
			
			document.getElementById("card_output").value = ASIMonitorInfo[count++];
			cardOutpChange(ASIMonitorInfo[count - 1]);
			document.getElementById("rf_port").value = ASIMonitorInfo[count++];
			document.getElementById("channel").value = ASIMonitorInfo[count++];
			
			if((ASIMonitorInfo[0] == 0) && (ASIMonitorInfo[5] == 0))
			{
				DisableInputMonitor(true);
				DisableOutputMonitor(true);
			}
		}
	}
	
	xmlhttp.send(getParams);
	return false;
}

function DisableApply()
{
	disabledButton(document.getElementById("Apply"), true);
}

function EnableApply()
{
	disabledButton(document.getElementById("Apply"), false);
}

function PageLoadHandler()
{
	DisableApply();
	document.body.style.cursor = "wait";
	window.status = "Retrieving data, please wait...";
	getDeviceInfo();
	
	document.body.style.cursor = "auto";
	window.status = "Done";
}

function pageRefresh()
{
	PageLoadHandler();
}

window.onload = function()
{
	var apply = document.getElementById("Apply");
	language = document.getElementById("language").value;
	applyDispay(parent.group, apply);
	PageLoadHandler();
}

function validateUDPPort(obj)
{
	if(validateNumber(obj.value) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for UDP Port.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的UDP端口。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	if((obj.value < 0) || (obj.value  > 65535))
	{
		if(language == 0)
		{
			alert("Valid range for UDP Port is 0 - 65535.");
		}
		else
		{
			alert("UDP端口号的范围是0 - 65535。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;  
}

function validateChannel(obj)
{
	var card_outp_idx = document.getElementById("card_output").value;
	var chMax = parseInt(cardChMax[card_outp_idx]);
	if(chMax == 0)
	{
		if(language == 0)
		{
			alert("No Card.");
		}
		else
		{
			alert("此槽位无卡。");
		}
		return false;
	}
	if(validateNumber(obj.value) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Channel.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的频点序号。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	if((obj.value < 1) || (obj.value  > chMax))
	{
		if(language == 0)
		{
			alert("Valid range for Channel is 1 - " + chMax + ".");
		}
		else
		{
			alert("频点序号的范围是1 - " + chMax + "。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;  
}

function validateIP(obj)
{
	if(Validate_IP_Format(obj.value) == false)
	{		
		if(language == 0)
		{
			alert("Please input a valid destination IP address.");
		}
		else
		{
			alert("请输入正确的目的IP地址。");
		}
		setTimeout(function() {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function SetASIMonitorInfo()
{
	var getParams = "type=25&cmd=2";
	var asi_monitor_type;
	if(document.getElementById("input_monitor_enable").checked == true)
	{
		var card_in_idx = document.getElementById("card_input").value;
		var chMax = parseInt(cardChMax[card_in_idx]);
		if(chMax == 0)
		{
			if(language == 0)
			{
				alert("No Card.");
			}
			else
			{
				alert("此槽位无卡。");
			}
			return false;
		}
		var dst_ip_addr = document.getElementById("dst_ip_addr")
		var udp_port = document.getElementById("udp_port");

		if((validateIP(dst_ip_addr) == false) || (validateUDPPort(udp_port) == false))
		{
			return false;
		}
		else
		{
			asi_monitor_type = INPUT_MONITOR;
			getParams = getParams + "&" + "asi_monitor_type=" + asi_monitor_type;
	
			var card_input = document.getElementById("card_input").value;
			getParams = getParams + "&" + "card_input=" + card_input;
			
			var gbe_port = document.getElementById("gbe_port").value;
			getParams = getParams + "&" + "gbe_port=" + gbe_port;
			
			getParams = getParams + "&" + "dst_ip_addr=" + dst_ip_addr.value;
	
			getParams = getParams + "&" + "udp_port=" + udp_port.value;
		}
	}
	else if(document.getElementById("output_monitor_enable").checked == true)
	{
		var channel = document.getElementById("channel");
		if(validateChannel(channel) == false)
		{
			return false;
		}
		else
		{
			asi_monitor_type = OUTPUT_MONITOR;
			getParams = getParams + "&" + "asi_monitor_type=" + asi_monitor_type;
	
			var card_output = document.getElementById("card_output").value;
			getParams = getParams + "&" + "card_output=" + card_output;
			
			var rf_port = document.getElementById("rf_port").value;
			getParams = getParams + "&" + "rf_port=" + rf_port;
			
			getParams = getParams + "&" + "channel=" + channel.value;
		}
	}
	else
	{
		getParams = getParams + "&" + "asi_monitor_type=0";
	}

	var xmlhttp = getHTTPObject();
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			var response = parseInt(xmlhttp.responseText.slice(7, -8), 10);
			if(response == 0)
			{
				if(language == 0)
				{
					alert("ASI monitor configurations update successfully.");
				}
				else
				{
					alert("ASI监控参数已设置成功。");
				}
			}
			else
			{
				alert(returnError[language][response]);
			}
			PageLoadHandler();
		}
	}
	
	xmlhttp.send(getParams);
	return true;
}

function SetASIMonitor()
{
	DisableApply();
	document.body.style.cursor = "wait";
	window.status = "Updating asi monitor information, please wait...";
	SetASIMonitorInfo();		
}
